#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Tower of PowersMod01.fsh   by   domrally  
//https://www.shadertoy.com/view/DstfW7
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

/// by Dom Mandy in 2023
//common //
/// This page of color space tools adapted from (2022): 
///    https://www.shadertoy.com/view/flSyWz
/// by Björn Ottosson: 
///    https://www.shadertoy.com/user/bjornornorn


const float M_PI = 3.1415926535897932384626433832795;

float cbrt( float x )
{
    return sign(x)*pow(abs(x),1.0f/3.0f);
}

float srgb_transfer_function(float a)
{
	return .0031308f >= a ? 12.92f * a : 1.055f * pow(a, .4166666666666667f) - .055f;
}

float srgb_transfer_function_inv(float a)
{
	return .04045f < a ? pow((a + .055f) / 1.055f, 2.4f) : a / 12.92f;
}

vec3 linear_srgb_to_oklab(vec3 c)
{
	float l = 0.4122214708f * c.r + 0.5363325363f * c.g + 0.0514459929f * c.b;
	float m = 0.2119034982f * c.r + 0.6806995451f * c.g + 0.1073969566f * c.b;
	float s = 0.0883024619f * c.r + 0.2817188376f * c.g + 0.6299787005f * c.b;

	float l_ = cbrt(l);
	float m_ = cbrt(m);
	float s_ = cbrt(s);

	return vec3(
		0.2104542553f * l_ + 0.7936177850f * m_ - 0.0040720468f * s_,
		1.9779984951f * l_ - 2.4285922050f * m_ + 0.4505937099f * s_,
		0.0259040371f * l_ + 0.7827717662f * m_ - 0.8086757660f * s_
	);
}

vec3 oklab_to_linear_srgb(vec3 c)
{
	float l_ = c.x + 0.3963377774f * c.y + 0.2158037573f * c.z;
	float m_ = c.x - 0.1055613458f * c.y - 0.0638541728f * c.z;
	float s_ = c.x - 0.0894841775f * c.y - 1.2914855480f * c.z;

	float l = l_ * l_ * l_;
	float m = m_ * m_ * m_;
	float s = s_ * s_ * s_;

	return vec3(
		+4.0767416621f * l - 3.3077115913f * m + 0.2309699292f * s,
		-1.2684380046f * l + 2.6097574011f * m - 0.3413193965f * s,
		-0.0041960863f * l - 0.7034186147f * m + 1.7076147010f * s
	);
}

// Finds the maximum saturation possible for a given hue that fits in sRGB
// Saturation here is defined as S = C/L
// a and b must be normalized so a^2 + b^2 == 1
float compute_max_saturation(float a, float b)
{
	// Max saturation will be when one of r, g or b goes below zero.

	// Select different coefficients depending on which component goes below zero first
	float k0, k1, k2, k3, k4, wl, wm, ws;

	if (-1.88170328f * a - 0.80936493f * b > 1.f)
	{
		// Red component
		k0 = +1.19086277f; k1 = +1.76576728f; k2 = +0.59662641f; k3 = +0.75515197f; k4 = +0.56771245f;
		wl = +4.0767416621f; wm = -3.3077115913f; ws = +0.2309699292f;
	}
	else if (1.81444104f * a - 1.19445276f * b > 1.f)
	{
		// Green component
		k0 = +0.73956515f; k1 = -0.45954404f; k2 = +0.08285427f; k3 = +0.12541070f; k4 = +0.14503204f;
		wl = -1.2684380046f; wm = +2.6097574011f; ws = -0.3413193965f;
	}
	else
	{
		// Blue component
		k0 = +1.35733652f; k1 = -0.00915799f; k2 = -1.15130210f; k3 = -0.50559606f; k4 = +0.00692167f;
		wl = -0.0041960863f; wm = -0.7034186147f; ws = +1.7076147010f;
	}

	// Approximate max saturation using a polynomial:
	float S = k0 + k1 * a + k2 * b + k3 * a * a + k4 * a * b;

	// Do one step Halley's method to get closer
	// this gives an error less than 10e6, except for some blue hues where the dS/dh is close to infinite
	// this should be sufficient for most applications, otherwise do two/three steps 

	float k_l = +0.3963377774f * a + 0.2158037573f * b;
	float k_m = -0.1055613458f * a - 0.0638541728f * b;
	float k_s = -0.0894841775f * a - 1.2914855480f * b;

	{
		float l_ = 1.f + S * k_l;
		float m_ = 1.f + S * k_m;
		float s_ = 1.f + S * k_s;

		float l = l_ * l_ * l_;
		float m = m_ * m_ * m_;
		float s = s_ * s_ * s_;

		float l_dS = 3.f * k_l * l_ * l_;
		float m_dS = 3.f * k_m * m_ * m_;
		float s_dS = 3.f * k_s * s_ * s_;

		float l_dS2 = 6.f * k_l * k_l * l_;
		float m_dS2 = 6.f * k_m * k_m * m_;
		float s_dS2 = 6.f * k_s * k_s * s_;

		float f = wl * l + wm * m + ws * s;
		float f1 = wl * l_dS + wm * m_dS + ws * s_dS;
		float f2 = wl * l_dS2 + wm * m_dS2 + ws * s_dS2;

		S = S - f * f1 / (f1 * f1 - 0.5f * f * f2);
	}

	return S;
}

// finds L_cusp and C_cusp for a given hue
// a and b must be normalized so a^2 + b^2 == 1
vec2 find_cusp(float a, float b)
{
	// First, find the maximum saturation (saturation S = C/L)
	float S_cusp = compute_max_saturation(a, b);

	// Convert to linear sRGB to find the first point where at least one of r,g or b >= 1:
	vec3 rgb_at_max = oklab_to_linear_srgb(vec3( 1, S_cusp * a, S_cusp * b ));
	float L_cusp = cbrt(1.f / max(max(rgb_at_max.r, rgb_at_max.g), rgb_at_max.b));
	float C_cusp = L_cusp * S_cusp;

	return vec2( L_cusp , C_cusp );
}

// Finds intersection of the line defined by 
// L = L0 * (1 - t) + t * L1;
// C = t * C1;
// a and b must be normalized so a^2 + b^2 == 1
float find_gamut_intersection(float a, float b, float L1, float C1, float L0, vec2 cusp)
{
	// Find the intersection for upper and lower half seprately
	float t;
	if (((L1 - L0) * cusp.y - (cusp.x - L0) * C1) <= 0.f)
	{
		// Lower half

		t = cusp.y * L0 / (C1 * cusp.x + cusp.y * (L0 - L1));
	}
	else
	{
		// Upper half

		// First intersect with triangle
		t = cusp.y * (L0 - 1.f) / (C1 * (cusp.x - 1.f) + cusp.y * (L0 - L1));

		// Then one step Halley's method
		{
			float dL = L1 - L0;
			float dC = C1;

			float k_l = +0.3963377774f * a + 0.2158037573f * b;
			float k_m = -0.1055613458f * a - 0.0638541728f * b;
			float k_s = -0.0894841775f * a - 1.2914855480f * b;

			float l_dt = dL + dC * k_l;
			float m_dt = dL + dC * k_m;
			float s_dt = dL + dC * k_s;


			// If higher accuracy is required, 2 or 3 iterations of the following block can be used:
			{
				float L = L0 * (1.f - t) + t * L1;
				float C = t * C1;

				float l_ = L + C * k_l;
				float m_ = L + C * k_m;
				float s_ = L + C * k_s;

				float l = l_ * l_ * l_;
				float m = m_ * m_ * m_;
				float s = s_ * s_ * s_;

				float ldt = 3.f * l_dt * l_ * l_;
				float mdt = 3.f * m_dt * m_ * m_;
				float sdt = 3.f * s_dt * s_ * s_;

				float ldt2 = 6.f * l_dt * l_dt * l_;
				float mdt2 = 6.f * m_dt * m_dt * m_;
				float sdt2 = 6.f * s_dt * s_dt * s_;

				float r = 4.0767416621f * l - 3.3077115913f * m + 0.2309699292f * s - 1.f;
				float r1 = 4.0767416621f * ldt - 3.3077115913f * mdt + 0.2309699292f * sdt;
				float r2 = 4.0767416621f * ldt2 - 3.3077115913f * mdt2 + 0.2309699292f * sdt2;

				float u_r = r1 / (r1 * r1 - 0.5f * r * r2);
				float t_r = -r * u_r;

				float g = -1.2684380046f * l + 2.6097574011f * m - 0.3413193965f * s - 1.f;
				float g1 = -1.2684380046f * ldt + 2.6097574011f * mdt - 0.3413193965f * sdt;
				float g2 = -1.2684380046f * ldt2 + 2.6097574011f * mdt2 - 0.3413193965f * sdt2;

				float u_g = g1 / (g1 * g1 - 0.5f * g * g2);
				float t_g = -g * u_g;

				float b = -0.0041960863f * l - 0.7034186147f * m + 1.7076147010f * s - 1.f;
				float b1 = -0.0041960863f * ldt - 0.7034186147f * mdt + 1.7076147010f * sdt;
				float b2 = -0.0041960863f * ldt2 - 0.7034186147f * mdt2 + 1.7076147010f * sdt2;

				float u_b = b1 / (b1 * b1 - 0.5f * b * b2);
				float t_b = -b * u_b;

				t_r = u_r >= 0.f ? t_r : 10000.f;
				t_g = u_g >= 0.f ? t_g : 10000.f;
				t_b = u_b >= 0.f ? t_b : 10000.f;

				t += min(t_r, min(t_g, t_b));
			}
		}
	}

	return t;
}

float find_gamut_intersection(float a, float b, float L1, float C1, float L0)
{
	// Find the cusp of the gamut triangle
	vec2 cusp = find_cusp(a, b);

	return find_gamut_intersection(a, b, L1, C1, L0, cusp);
}

vec3 softSaturate(vec3 x, vec3 a)
{
    a = 1.0+a;
    x = min(x, a);
    vec3 b = (a-1.0)*sqrt(a/(2.0-a));
    return 1.0 - (sqrt((x-a)*(x-a) + b*b) - b)/(sqrt(a*a+b*b)-b);
}

vec3 softClipColorOutsideGamutOnly(vec3 color)
{
    // soft clipping scaled to only have an effect if the color is outside the gamut
    
    float middle = 0.2;
    
    vec3 x = color-middle;

    vec3 xsgn = sign(x);
    vec3 xscale = 0.5 + xsgn*(0.5-middle);
    x /= xscale;
    
    vec3 absX = abs(x);
    
    float maxX = max(max(1.0,absX.r), max(absX.g, absX.b));
    
    float softness_scale = 0.5;
    float softness = softness_scale*(maxX-1.0);
    softness = softness/(1.0+softness);
    
    return middle + xscale*xsgn*softSaturate(absX, vec3(softness));
}

vec2 approximateShape(float a, float b)
{
    float C = sqrt(a*a+b*b);
    a /= C;
    b /= C;
    
    float a2 = 2.0*a*b;
    float b2 = a*a - b*b;
    float a3 = 3.0*a - 4.0*a*a*a;
    float b3 = -3.0*b + 4.0*b*b*b;    
  
    // softness_scale 0.0
    // Estimated using https://colab.research.google.com/drive/1qQA3xhBX3iB8FT8558e5QQnmVZ5Jh1Fb?usp=sharing
    return vec2(
        1.63804674 + -0.08431713*a +  0.27624179*b +  0.08737741*a2 +  0.13917503*b2 + 0.03691021*a3 +  0.03060615*b3,
        0.23438507 + 0.05736278*a  +  -0.09674117*b +  0.024447*a2 + 0.00469441*b2 + 0.01253234*a3 + 0.00741058*b3
    );
}

float Srgb1(float c){return(c<0.0031308?c*12.92:1.055*pow(c,0.41666)-0.055);}
vec3 Srgb3(vec3 c){return vec3(Srgb1(c.r),Srgb1(c.g),Srgb1(c.b));}

vec4 oklch2rgb(float lightness, float chroma, float hue) {
    chroma = mix(.0, -.25 * log(.55), chroma);
    // Translate to Lab color space
    float a = cos(hue);
    float b = sin(hue);
    vec2 gamut = approximateShape(a, b);
    float saturation = 1. / (gamut.y / (1. - lightness) + gamut.x / lightness);
    float colorfulness = min(chroma, saturation);
    a *= colorfulness;
    b *= colorfulness;
    vec3 color = oklab_to_linear_srgb(vec3(lightness, a, b));
    color = softClipColorOutsideGamutOnly(color);
    color = clamp(color, 0., 1.);
    color = Srgb3(color);
    
    return vec4(color, 1.);
}

//end common  //

/*
https://mathworld.wolfram.com/ComplexExponentiation.html
*/
mat3x2 exponentiate(mat3x2 a, mat3x2 b) {
    mat3x2 c;
    
    float mag = dot(a[0], a[0]);
    float arg = atan(a[0].g, a[0].r);
    
    float scale = pow(mag, b[0].r / 2.) * exp(-b[0].g * arg);
    float angle = b[0].r * arg + b[0].g * log(mag) / 2.;
    
    c[0].r = scale * cos(angle);
    c[0].g = scale * sin(angle);
    
    c[1].r = (.5 * log(mag)) 
           * cos(angle) * pow(mag, b[0].r / 2.) * exp(-b[0].g * arg) 
           - scale * sin(angle) * (arg + 1. / (2. * (2. * a[0].r)));
    c[1].g = (- arg) 
           * sin(angle) * pow(mag, b[0].r / 2.) * exp(-b[0].g * arg) 
           + scale * cos(angle) * (arg + 1. / (2. * (2. * a[0].g)));
           
    c[2].r = log(mag)
           * cos(angle) * pow(mag, b[0].r / 2.) * exp(-b[0].g * arg) 
           / (4. * mag)
           + log(mag) * log(mag)
           * cos(angle) * pow(mag, b[0].r / 2.) * exp(-b[0].g * arg) 
           / (4.)
           - scale * sin(angle) * (arg + 1. / (2. * (2. * a[0].r)));
    c[2].g = -arg
           * sin(angle) * pow(mag, b[0].r / 2.) * exp(-b[0].g * arg) 
           -arg
           * sin(angle) * pow(mag, b[0].r / 2.) * exp(-b[0].g * arg) 
           + scale * cos(angle) * (arg + 1. / (2. * (2. * a[0].g)));
    
    return c;

}
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{  
    // Pixel space to view space
    vec2 uv = 3.2 * (2. * fragCoord - iResolution.xy) / iResolution.x;
    vec2 uvMouse = 2. * iMouse.xy - iResolution.xy;
      
    mat3x2 orbit, initial;

    orbit[0] = initial[0] = uv;
    orbit[1] = initial[1] = vec2(1);
            
    // Simulate the trajectory for this pixel relative to the center of the image.
    vec2 trapped;
    float radius = 9e9;
    float escape;
    for (float i; i < 31.; i++) {
        // This recursion generates chaotic behavior
        orbit = exponentiate(initial, orbit);
        // We want to record the nearest approach as the pixel orbits around the image center.
        float flyby = dot(orbit[0], orbit[0]);
        //flyby = distance(orbit, uv);
        //flyby = abs(orbit.y - uv.y);
        radius = min(radius, flyby);
        // The closest point is called the orbit trap.
        //    https://en.wikipedia.org/wiki/Orbit_trap#Point_based
        trapped = trapped * float(radius != flyby) + float(radius == flyby) * orbit[0];
        
        if (flyby > 9e9) break;
        
        escape += float(escape == 0.) * step(400., flyby) * i;
    }
    
    // Find the angle of closest approach of the orbit trap: 
    //    https://en.wikipedia.org/wiki/Argument_(complex_analysis)
    float angle = atan(trapped.y, trapped.x);
    //angle = atan(accumulated.y, accumulated.x);
    // Match the angle to the color wheel: 
    //    https://en.wikipedia.org/wiki/Color_wheel
    float hue = angle - atan(uvMouse.y, uvMouse.x) + iTime;
    hue *= float(!isnan(hue)); 
    hue += -float(isnan(hue)) * atan(uvMouse.y, uvMouse.x) + iTime;
    
    // shade crab by escape time
    float estimate = smoothstep(0., 30., escape);
    // The derivatives need to be scaled by their binomial taylor coefficients
    vec3 differentials = vec3(
        length(orbit[0]),
        length(orbit[1]),
        2. * length(orbit[2])
    );
    // calculate derivative based estimate
    float test = log(differentials[0]) * .5 * (differentials[0] / differentials[1] +  differentials[1] / differentials[2]);
    estimate = max(estimate, smoothstep(0., 1.5, pow(test, .2)));
    // add shading from orbit traps for bifurcation structure
    estimate = max(estimate, smoothstep(0., 2., pow(2., length(trapped))));
    
    // Paint the pixel
    fragColor = oklch2rgb(estimate, estimate, hue);



/*
REFERENCES

distance

iq 2013
https://www.shadertoy.com/view/lsX3W4

orbit traps

DeltaT 2023
https://www.shadertoy.com/view/csSyzy

athibaul 2021
https://www.shadertoy.com/view/fdt3zX

piotrekli 2016
https://www.shadertoy.com/view/4lK3Dc

Kramin 2015
https://www.shadertoy.com/view/4st3Wn
*/


/*
FUTHER READING

hyperoperations

https://en.wikipedia.org/wiki/Tetration
https://en.wikipedia.org/wiki/Iterated_function#Fractional_iterates_and_flows,_and_negative_iterates

fractals

https://en.wikipedia.org/wiki/Julia_set
https://en.wikipedia.org/wiki/Orbit_trap
https://en.wikipedia.org/wiki/Color_wheel
https://en.wikipedia.org/wiki/Versine#Definitions
https://en.wikipedia.org/wiki/Argument_(complex_analysis)

differentials

https://en.wikipedia.org/wiki/Product_rule
https://en.wikipedia.org/wiki/Gradient_descent
https://en.wikipedia.org/wiki/Newton%27s_method
https://en.wikipedia.org/wiki/Householder%27s_method
https://en.wikipedia.org/wiki/Automatic_differentiation
*/
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

